# MetinPaylaş

MetinPaylaş, hızlı ve kolay metin paylaşımı yapabileceğiniz bir web platformudur. Kullanıcılar kayıt olmadan metin paylaşabilir ve benzersiz bağlantılar oluşturabilir.

## Özellikler

- Hızlı metin paylaşımı
- Benzersiz bağlantı oluşturma
- Şifre korumalı içerikler
- Otomatik silinme süresi belirleme
- Markdown desteği
- Açık/koyu tema desteği
- Mobil uyumlu tasarım
- QR kod ile paylaşım

## Kurulum

1. Dosyaları web sunucunuza yükleyin
2. `veritabani.sql` dosyasını MySQL veritabanınıza içe aktarın
3. `includes/config.php` dosyasındaki veritabanı bağlantı bilgilerini düzenleyin
4. Süresi dolan paylaşımların otomatik temizlenmesi için `temizle.php` dosyasını cron job olarak ayarlayın

## Sistem Gereksinimleri

- PHP 8.0 veya üzeri
- MySQL veritabanı
- mod_rewrite desteği (isteğe bağlı)

## Güvenlik

- XSS koruması için tüm metin çıktıları `htmlspecialchars()` ile işlenir
- SQL Injection koruması için PDO ve prepared statements kullanılır
- Rate limit ile çok fazla istek engellenir
- Şifreler güvenli bir şekilde hash'lenir

## Lisans

Bu proje açık kaynaklıdır ve MIT lisansı altında dağıtılmaktadır.

