<?php
/**
 * MetinPaylaş - Admin Site Ayarları
 */

require_once '../includes/config.php';
require_once '../includes/functions.php';

// Admin girişi kontrolü
if (!isset($_SESSION['admin_giris']) || $_SESSION['admin_giris'] !== true) {
    header('Location: index.php');
    exit;
}

// Ayarları getir
$ayarlar = ayarlariGetir();
$varsayilan_tema = isset($ayarlar['tema']) ? $ayarlar['tema'] : 'light';

$mesaj = '';
$mesaj_turu = '';

// Ayar güncelleme işlemi
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['ayarlari_guncelle'])) {
    $guncellenecek_ayarlar = [
        'site_baslik' => $_POST['site_baslik'] ?? '',
        'site_aciklama' => $_POST['site_aciklama'] ?? '',
        'max_dosya_boyutu' => (int)($_POST['max_dosya_boyutu'] ?? 5) * 1024 * 1024, // MB'den byte'a çevir
        'izin_verilen_uzantilar' => $_POST['izin_verilen_uzantilar'] ?? '',
        'kayit_acik' => isset($_POST['kayit_acik']) ? '1' : '0',
        'tema' => $_POST['tema'] ?? 'light',
        'markdown_varsayilan' => isset($_POST['markdown_varsayilan']) ? '1' : '0'
    ];
    
    $basarili_sayac = 0;
    $hatalar = [];
    foreach ($guncellenecek_ayarlar as $anahtar => $deger) {
        $sonuc = ayarGuncelle($anahtar, $deger);
        if ($sonuc) {
            $basarili_sayac++;
        } else {
            $hatalar[] = $anahtar;
        }
    }
    
    if ($basarili_sayac > 0) {
        $mesaj = "$basarili_sayac ayar başarıyla güncellendi.";
        if (!empty($hatalar)) {
            $mesaj .= " Hata olan ayarlar: " . implode(', ', $hatalar);
        }
        $mesaj_turu = 'success';
        // Ayarları yeniden yükle
        $ayarlar = ayarlariGetir();
    } else {
        $mesaj = 'Hiçbir ayar güncellenemedi. Hatalar: ' . implode(', ', $hatalar);
        $mesaj_turu = 'danger';
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Site Ayarları - Admin Panel</title>
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/admin.css">
</head>
<body data-bs-theme="<?php echo $varsayilan_tema; ?>">
    <!-- Sidebar -->
    <div class="sidebar">
        <div class="sidebar-header">
            <h5 class="mb-0"><i class="bi bi-shield-lock text-primary me-2"></i>Admin Panel</h5>
            <small class="text-muted">MetinPaylaş</small>
        </div>
        <nav class="sidebar-nav">
            <a href="dashboard.php" class="nav-link"><i class="bi bi-speedometer2"></i>Dashboard</a>
            <a href="paylasimlar.php" class="nav-link"><i class="bi bi-file-text"></i>Paylaşımlar</a>
            <a href="kullanicilar.php" class="nav-link"><i class="bi bi-people"></i>Kullanıcılar</a>
            <a href="ayarlar.php" class="nav-link active"><i class="bi bi-gear"></i>Site Ayarları</a>
            <a href="istatistikler.php" class="nav-link"><i class="bi bi-bar-chart"></i>İstatistikler</a>
            <a href="guvenlik.php" class="nav-link"><i class="bi bi-shield-check"></i>Güvenlik</a>
            <hr class="my-3">
            <a href="../index.php" class="nav-link" target="_blank"><i class="bi bi-box-arrow-up-right"></i>Siteyi Görüntüle</a>
            <a href="cikis.php" class="nav-link text-danger"><i class="bi bi-box-arrow-right"></i>Çıkış Yap</a>
        </nav>
    </div>
    
    <!-- Ana İçerik -->
    <div class="main-content">
        <div class="top-bar">
            <div>
                <h4 class="mb-0">Site Ayarları</h4>
                <small class="text-muted">Sitenin genel ayarlarını yönetin</small>
            </div>
            <div>
                <button class="btn btn-outline-secondary btn-sm me-2" id="temaDegistir" title="Tema Değiştir">
                    <i class="bi bi-sun"></i>
                </button>
                <span class="badge bg-primary"><?php echo $_SESSION['admin_yetki']; ?></span>
            </div>
        </div>
        
        <?php if (!empty($mesaj)): ?>
            <div class="alert alert-<?php echo $mesaj_turu; ?> alert-dismissible fade show">
                <?php echo htmlspecialchars($mesaj); ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>
        
        
        <!-- Ayarlar Formu -->
        <div class="row">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="bi bi-gear me-2"></i>Genel Ayarlar</h5>
                    </div>
                    <div class="card-body">
                        <form method="post">
                            <!-- Site Bilgileri -->
                            <div class="mb-4">
                                <h6 class="text-primary mb-3">Site Bilgileri</h6>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label">Site Başlığı</label>
                                            <input type="text" class="form-control" name="site_baslik" 
                                                   value="<?php echo htmlspecialchars($ayarlar['site_baslik'] ?? ''); ?>" required>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label">Tema</label>
                                            <select class="form-select" name="tema">
                                                <option value="light" <?php echo ($ayarlar['tema'] ?? '') === 'light' ? 'selected' : ''; ?>>Açık Tema</option>
                                                <option value="dark" <?php echo ($ayarlar['tema'] ?? '') === 'dark' ? 'selected' : ''; ?>>Koyu Tema</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Site Açıklaması</label>
                                    <textarea class="form-control" name="site_aciklama" rows="3"><?php echo htmlspecialchars($ayarlar['site_aciklama'] ?? ''); ?></textarea>
                                </div>
                            </div>
                            
                            <!-- Dosya Ayarları -->
                            <div class="mb-4">
                                <h6 class="text-primary mb-3">Dosya Yükleme Ayarları</h6>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label">Maksimum Dosya Boyutu (MB)</label>
                                            <input type="number" class="form-control" name="max_dosya_boyutu" 
                                                   value="<?php echo round(($ayarlar['max_dosya_boyutu'] ?? 5242880) / 1024 / 1024); ?>" 
                                                   min="1" max="100">
                                            <div class="form-text">Yüklenebilecek maksimum dosya boyutu</div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label">İzin Verilen Uzantılar</label>
                                            <input type="text" class="form-control" name="izin_verilen_uzantilar" 
                                                   value="<?php echo htmlspecialchars($ayarlar['izin_verilen_uzantilar'] ?? ''); ?>"
                                                   placeholder="jpg,jpeg,png,gif">
                                            <div class="form-text">Virgülle ayırarak yazın</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Özellik Ayarları -->
                            <div class="mb-4">
                                <h6 class="text-primary mb-3">Özellik Ayarları</h6>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-check mb-3">
                                            <input class="form-check-input" type="checkbox" name="kayit_acik" 
                                                   <?php echo ($ayarlar['kayit_acik'] ?? '0') === '1' ? 'checked' : ''; ?>>
                                            <label class="form-check-label">
                                                Kullanıcı Kaydı Açık
                                            </label>
                                            <div class="form-text">Yeni kullanıcıların kayıt olmasına izin ver</div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-check mb-3">
                                            <input class="form-check-input" type="checkbox" name="markdown_varsayilan" 
                                                   <?php echo ($ayarlar['markdown_varsayilan'] ?? '0') === '1' ? 'checked' : ''; ?>>
                                            <label class="form-check-label">
                                                Markdown Varsayılan
                                            </label>
                                            <div class="form-text">Yeni paylaşımlarda Markdown editörü açık olsun</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="d-flex justify-content-end">
                                <button type="submit" name="ayarlari_guncelle" class="btn btn-primary">
                                    <i class="bi bi-check-lg me-1"></i>Ayarları Kaydet
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            
            <!-- Yan Panel -->
            <div class="col-lg-4">
                <!-- Sistem Bilgileri -->
                <div class="card mb-4">
                    <div class="card-header">
                        <h6 class="mb-0"><i class="bi bi-info-circle me-2"></i>Sistem Bilgileri</h6>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-6">
                                <div class="text-center">
                                    <div class="h5 mb-0 text-primary"><?php echo PHP_VERSION; ?></div>
                                    <small class="text-muted">PHP Sürümü</small>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="text-center">
                                    <div class="h5 mb-0 text-success">
                                        <?php
                                        $db = baglan();
                                        $version = $db->query("SELECT VERSION() as version")->fetch();
                                        echo explode('-', $version['version'])[0];
                                        ?>
                                    </div>
                                    <small class="text-muted">MySQL Sürümü</small>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="text-center">
                                    <div class="h5 mb-0 text-warning">
                                        <?php echo round(disk_free_space('.') / 1024 / 1024 / 1024, 1); ?>GB
                                    </div>
                                    <small class="text-muted">Boş Disk Alanı</small>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="text-center">
                                    <div class="h5 mb-0 text-info">
                                        <?php echo ini_get('memory_limit'); ?>
                                    </div>
                                    <small class="text-muted">Bellek Limiti</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Hızlı İşlemler -->
                <div class="card">
                    <div class="card-header">
                        <h6 class="mb-0"><i class="bi bi-lightning me-2"></i>Hızlı İşlemler</h6>
                    </div>
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <button class="btn btn-outline-primary btn-sm" onclick="temizleCache()">
                                <i class="bi bi-arrow-clockwise me-1"></i>Cache Temizle
                            </button>
                            <button class="btn btn-outline-warning btn-sm" onclick="yedekAl()">
                                <i class="bi bi-download me-1"></i>Veritabanı Yedeği Al
                            </button>
                            <button class="btn btn-outline-info btn-sm" onclick="logGoruntule()">
                                <i class="bi bi-file-text me-1"></i>Hata Logları
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Tema değiştirme
        document.addEventListener('DOMContentLoaded', function() {
            const themeToggle = document.getElementById('temaDegistir');
            if (themeToggle) {
                let currentTheme = document.body.getAttribute('data-bs-theme') || 'light';
                updateThemeIcon(currentTheme);
                
                themeToggle.addEventListener('click', function() {
                    const newTheme = currentTheme === 'dark' ? 'light' : 'dark';
                    document.body.setAttribute('data-bs-theme', newTheme);
                    document.documentElement.setAttribute('data-bs-theme', newTheme);
                    localStorage.setItem('theme', newTheme);
                    updateThemeIcon(newTheme);
                    currentTheme = newTheme;
                    
                    document.body.classList.add('theme-transition');
                    setTimeout(() => document.body.classList.remove('theme-transition'), 300);
                    
                    fetch('tema-degistir.php', {
                        method: 'POST',
                        headers: { 'Content-Type': 'application/json' },
                        body: JSON.stringify({ tema: newTheme })
                    }).catch(console.error);
                });
                
                function updateThemeIcon(theme) {
                    const icon = themeToggle.querySelector('i');
                    if (icon) icon.className = theme === 'dark' ? 'bi bi-sun' : 'bi bi-moon';
                }
            }
        });
        
        // Hızlı işlemler
        function temizleCache() {
            alert('Cache temizleme özelliği yakında eklenecek.');
        }
        
        function yedekAl() {
            alert('Veritabanı yedekleme özelliği yakında eklenecek.');
        }
        
        function logGoruntule() {
            alert('Log görüntüleme özelliği yakında eklenecek.');
        }
    </script>
</body>
</html>
