<?php
/**
 * MetinPaylaş - Admin Güvenlik
 */

require_once '../includes/config.php';
require_once '../includes/functions.php';

// Admin girişi kontrolü
if (!isset($_SESSION['admin_giris']) || $_SESSION['admin_giris'] !== true) {
    header('Location: index.php');
    exit;
}

// Ayarları getir
$ayarlar = ayarlariGetir();
$varsayilan_tema = isset($ayarlar['tema']) ? $ayarlar['tema'] : 'light';

$db = baglan();
$mesaj = '';
$mesaj_turu = '';

// Güvenlik işlemleri
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['sifre_degistir'])) {
        $mevcut_sifre = $_POST['mevcut_sifre'];
        $yeni_sifre = $_POST['yeni_sifre'];
        $yeni_sifre_tekrar = $_POST['yeni_sifre_tekrar'];
        
        // Mevcut şifreyi kontrol et
        $kullanici = $db->prepare("SELECT sifre FROM kullanicilar WHERE id = ?");
        $kullanici->execute([$_SESSION['admin_id']]);
        $kullanici_data = $kullanici->fetch();
        
        if (!password_verify($mevcut_sifre, $kullanici_data['sifre'])) {
            $mesaj = 'Mevcut şifreniz yanlış.';
            $mesaj_turu = 'danger';
        } elseif ($yeni_sifre !== $yeni_sifre_tekrar) {
            $mesaj = 'Yeni şifreler eşleşmiyor.';
            $mesaj_turu = 'danger';
        } elseif (strlen($yeni_sifre) < 6) {
            $mesaj = 'Yeni şifre en az 6 karakter olmalıdır.';
            $mesaj_turu = 'danger';
        } else {
            $yeni_sifre_hash = password_hash($yeni_sifre, PASSWORD_DEFAULT);
            $update = $db->prepare("UPDATE kullanicilar SET sifre = ? WHERE id = ?");
            if ($update->execute([$yeni_sifre_hash, $_SESSION['admin_id']])) {
                $mesaj = 'Şifreniz başarıyla güncellendi.';
                $mesaj_turu = 'success';
            } else {
                $mesaj = 'Şifre güncellenirken bir hata oluştu.';
                $mesaj_turu = 'danger';
            }
        }
    } elseif (isset($_POST['temizle_eski_paylasimlar'])) {
        // 30 günden eski paylaşımları sil
        $silinen = $db->exec("DELETE FROM paylasimlar WHERE tarih < DATE_SUB(NOW(), INTERVAL 30 DAY)");
        $mesaj = "$silinen adet eski paylaşım silindi.";
        $mesaj_turu = 'success';
    } elseif (isset($_POST['ip_engelle'])) {
        $ip = trim($_POST['engellenen_ip']);
        if (filter_var($ip, FILTER_VALIDATE_IP)) {
            // IP engelleme sistemi (basit bir örnek)
            $mesaj = "IP adresi $ip engellendi. (Bu özellik geliştirilecek)";
            $mesaj_turu = 'success';
        } else {
            $mesaj = 'Geçersiz IP adresi.';
            $mesaj_turu = 'danger';
        }
    }
}

// Son giriş denemeleri (örnek)
$son_girisler = $db->query("SELECT kullanici_adi, son_giris, son_giris_ip FROM kullanicilar WHERE son_giris IS NOT NULL ORDER BY son_giris DESC LIMIT 10")->fetchAll();

// Güvenlik istatistikleri
$guvenlik_stats = [
    'toplam_kullanici' => $db->query("SELECT COUNT(*) as count FROM kullanicilar")->fetch()['count'],
    'aktif_kullanici' => $db->query("SELECT COUNT(*) as count FROM kullanicilar WHERE durum = 1")->fetch()['count'],
    'admin_sayisi' => $db->query("SELECT COUNT(*) as count FROM kullanicilar WHERE yetki = 'admin'")->fetch()['count'],
    'sifreli_paylasim' => $db->query("SELECT COUNT(*) as count FROM paylasimlar WHERE sifre IS NOT NULL")->fetch()['count']
];

// En aktif IP'ler
$aktif_ipler = $db->query("SELECT ip_adresi, COUNT(*) as count FROM paylasimlar GROUP BY ip_adresi ORDER BY count DESC LIMIT 5")->fetchAll();
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Güvenlik - Admin Panel</title>
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/admin.css">
</head>
<body data-bs-theme="<?php echo $varsayilan_tema; ?>">
    <!-- Sidebar -->
    <div class="sidebar">
        <div class="sidebar-header">
            <h5 class="mb-0"><i class="bi bi-shield-lock text-primary me-2"></i>Admin Panel</h5>
            <small class="text-muted">MetinPaylaş</small>
        </div>
        <nav class="sidebar-nav">
            <a href="dashboard.php" class="nav-link"><i class="bi bi-speedometer2"></i>Dashboard</a>
            <a href="paylasimlar.php" class="nav-link"><i class="bi bi-file-text"></i>Paylaşımlar</a>
            <a href="kullanicilar.php" class="nav-link"><i class="bi bi-people"></i>Kullanıcılar</a>
            <a href="ayarlar.php" class="nav-link"><i class="bi bi-gear"></i>Site Ayarları</a>
            <a href="istatistikler.php" class="nav-link"><i class="bi bi-bar-chart"></i>İstatistikler</a>
            <a href="guvenlik.php" class="nav-link active"><i class="bi bi-shield-check"></i>Güvenlik</a>
            <hr class="my-3">
            <a href="../index.php" class="nav-link" target="_blank"><i class="bi bi-box-arrow-up-right"></i>Siteyi Görüntüle</a>
            <a href="cikis.php" class="nav-link text-danger"><i class="bi bi-box-arrow-right"></i>Çıkış Yap</a>
        </nav>
    </div>
    
    <!-- Ana İçerik -->
    <div class="main-content">
        <div class="top-bar">
            <div>
                <h4 class="mb-0">Güvenlik</h4>
                <small class="text-muted">Site güvenliği ve kullanıcı yönetimi</small>
            </div>
            <div>
                <button class="btn btn-outline-secondary btn-sm me-2" id="temaDegistir" title="Tema Değiştir">
                    <i class="bi bi-sun"></i>
                </button>
                <span class="badge bg-primary"><?php echo $_SESSION['admin_yetki']; ?></span>
            </div>
        </div>
        
        <?php if (!empty($mesaj)): ?>
            <div class="alert alert-<?php echo $mesaj_turu; ?> alert-dismissible fade show">
                <?php echo htmlspecialchars($mesaj); ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>
        
        <!-- Güvenlik İstatistikleri -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="stat-card">
                    <div class="d-flex align-items-center">
                        <div class="stat-icon bg-primary"><i class="bi bi-people"></i></div>
                        <div class="ms-3">
                            <p class="stat-number"><?php echo number_format($guvenlik_stats['toplam_kullanici']); ?></p>
                            <p class="stat-label">Toplam Kullanıcı</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stat-card">
                    <div class="d-flex align-items-center">
                        <div class="stat-icon bg-success"><i class="bi bi-person-check"></i></div>
                        <div class="ms-3">
                            <p class="stat-number"><?php echo number_format($guvenlik_stats['aktif_kullanici']); ?></p>
                            <p class="stat-label">Aktif Kullanıcı</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stat-card">
                    <div class="d-flex align-items-center">
                        <div class="stat-icon bg-warning"><i class="bi bi-shield-check"></i></div>
                        <div class="ms-3">
                            <p class="stat-number"><?php echo number_format($guvenlik_stats['admin_sayisi']); ?></p>
                            <p class="stat-label">Admin</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stat-card">
                    <div class="d-flex align-items-center">
                        <div class="stat-icon bg-danger"><i class="bi bi-lock"></i></div>
                        <div class="ms-3">
                            <p class="stat-number"><?php echo number_format($guvenlik_stats['sifreli_paylasim']); ?></p>
                            <p class="stat-label">Şifreli Paylaşım</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Güvenlik İşlemleri -->
        <div class="row">
            <div class="col-lg-6">
                <!-- Şifre Değiştirme -->
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="bi bi-key me-2"></i>Şifre Değiştir</h5>
                    </div>
                    <div class="card-body">
                        <form method="post">
                            <div class="mb-3">
                                <label class="form-label">Mevcut Şifre</label>
                                <input type="password" class="form-control" name="mevcut_sifre" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Yeni Şifre</label>
                                <input type="password" class="form-control" name="yeni_sifre" required minlength="6">
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Yeni Şifre (Tekrar)</label>
                                <input type="password" class="form-control" name="yeni_sifre_tekrar" required minlength="6">
                            </div>
                            <button type="submit" name="sifre_degistir" class="btn btn-primary">
                                <i class="bi bi-check-lg me-1"></i>Şifre Değiştir
                            </button>
                        </form>
                    </div>
                </div>
                
                <!-- IP Engelleme -->
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="bi bi-ban me-2"></i>IP Engelleme</h5>
                    </div>
                    <div class="card-body">
                        <form method="post">
                            <div class="mb-3">
                                <label class="form-label">IP Adresi</label>
                                <input type="text" class="form-control" name="engellenen_ip" 
                                       placeholder="192.168.1.1" required>
                                <div class="form-text">Engellemek istediğiniz IP adresini girin</div>
                            </div>
                            <button type="submit" name="ip_engelle" class="btn btn-warning">
                                <i class="bi bi-ban me-1"></i>IP Engelle
                            </button>
                        </form>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-6">
                <!-- Sistem Temizliği -->
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="bi bi-trash me-2"></i>Sistem Temizliği</h5>
                    </div>
                    <div class="card-body">
                        <div class="alert alert-warning">
                            <i class="bi bi-exclamation-triangle me-2"></i>
                            Bu işlemler geri alınamaz. Dikkatli olun!
                        </div>
                        
                        <form method="post" onsubmit="return confirm('30 günden eski tüm paylaşımlar silinecek. Emin misiniz?')">
                            <p>30 günden eski paylaşımları temizle:</p>
                            <button type="submit" name="temizle_eski_paylasimlar" class="btn btn-danger">
                                <i class="bi bi-trash me-1"></i>Eski Paylaşımları Sil
                            </button>
                        </form>
                    </div>
                </div>
                
                <!-- Güvenlik Durumu -->
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="bi bi-shield-check me-2"></i>Güvenlik Durumu</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <div class="d-flex justify-content-between align-items-center">
                                <span>PHP Sürümü</span>
                                <span class="badge bg-<?php echo version_compare(PHP_VERSION, '8.0', '>=') ? 'success' : 'warning'; ?>">
                                    <?php echo PHP_VERSION; ?>
                                </span>
                            </div>
                        </div>
                        <div class="mb-3">
                            <div class="d-flex justify-content-between align-items-center">
                                <span>HTTPS</span>
                                <span class="badge bg-<?php echo isset($_SERVER['HTTPS']) ? 'success' : 'warning'; ?>">
                                    <?php echo isset($_SERVER['HTTPS']) ? 'Aktif' : 'Pasif'; ?>
                                </span>
                            </div>
                        </div>
                        <div class="mb-3">
                            <div class="d-flex justify-content-between align-items-center">
                                <span>Session Güvenliği</span>
                                <span class="badge bg-success">Aktif</span>
                            </div>
                        </div>
                        <div class="mb-3">
                            <div class="d-flex justify-content-between align-items-center">
                                <span>SQL Injection Koruması</span>
                                <span class="badge bg-success">Aktif</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Son Girişler ve Aktif IP'ler -->
        <div class="row mt-4">
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="bi bi-clock-history me-2"></i>Son Girişler</h5>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>Kullanıcı</th>
                                        <th>Son Giriş</th>
                                        <th>IP</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($son_girisler as $giris): ?>
                                        <tr>
                                            <td><?php echo htmlspecialchars($giris['kullanici_adi']); ?></td>
                                            <td>
                                                <small><?php echo $giris['son_giris'] ? date('d.m.Y H:i', strtotime($giris['son_giris'])) : '-'; ?></small>
                                            </td>
                                            <td>
                                                <code><?php echo htmlspecialchars($giris['son_giris_ip'] ?? '-'); ?></code>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="bi bi-globe me-2"></i>En Aktif IP Adresleri</h5>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>IP Adresi</th>
                                        <th>Paylaşım Sayısı</th>
                                        <th>İşlem</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($aktif_ipler as $ip): ?>
                                        <tr>
                                            <td>
                                                <code><?php echo htmlspecialchars($ip['ip_adresi']); ?></code>
                                            </td>
                                            <td>
                                                <span class="badge bg-info"><?php echo number_format($ip['count']); ?></span>
                                            </td>
                                            <td>
                                                <button class="btn btn-sm btn-outline-warning" 
                                                        onclick="engelleIP('<?php echo htmlspecialchars($ip['ip_adresi']); ?>')">
                                                    <i class="bi bi-ban"></i>
                                                </button>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Tema değiştirme
        document.addEventListener('DOMContentLoaded', function() {
            const themeToggle = document.getElementById('temaDegistir');
            if (themeToggle) {
                let currentTheme = document.body.getAttribute('data-bs-theme') || 'light';
                updateThemeIcon(currentTheme);
                
                themeToggle.addEventListener('click', function() {
                    const newTheme = currentTheme === 'dark' ? 'light' : 'dark';
                    document.body.setAttribute('data-bs-theme', newTheme);
                    document.documentElement.setAttribute('data-bs-theme', newTheme);
                    localStorage.setItem('theme', newTheme);
                    updateThemeIcon(newTheme);
                    currentTheme = newTheme;
                    
                    document.body.classList.add('theme-transition');
                    setTimeout(() => document.body.classList.remove('theme-transition'), 300);
                    
                    fetch('tema-degistir.php', {
                        method: 'POST',
                        headers: { 'Content-Type': 'application/json' },
                        body: JSON.stringify({ tema: newTheme })
                    }).catch(console.error);
                });
                
                function updateThemeIcon(theme) {
                    const icon = themeToggle.querySelector('i');
                    if (icon) icon.className = theme === 'dark' ? 'bi bi-sun' : 'bi bi-moon';
                }
            }
        });
        
        // IP engelleme
        function engelleIP(ip) {
            if (confirm('Bu IP adresini engellemek istediğinizden emin misiniz?\n\nIP: ' + ip)) {
                const form = document.createElement('form');
                form.method = 'post';
                form.innerHTML = '<input type="hidden" name="engellenen_ip" value="' + ip + '"><input type="hidden" name="ip_engelle" value="1">';
                document.body.appendChild(form);
                form.submit();
            }
        }
    </script>
</body>
</html>
