<?php
/**
 * MetinPaylaş - Admin İstatistikler
 */

require_once '../includes/config.php';
require_once '../includes/functions.php';

// Admin girişi kontrolü
if (!isset($_SESSION['admin_giris']) || $_SESSION['admin_giris'] !== true) {
    header('Location: index.php');
    exit;
}

// Ayarları getir
$ayarlar = ayarlariGetir();
$varsayilan_tema = isset($ayarlar['tema']) ? $ayarlar['tema'] : 'light';

$db = baglan();

// Genel istatistikler
$stats = [
    'toplam_paylasim' => $db->query("SELECT COUNT(*) as count FROM paylasimlar")->fetch()['count'],
    'toplam_goruntulenme' => $db->query("SELECT SUM(goruntulenme) as total FROM paylasimlar")->fetch()['total'] ?? 0,
    'bugun_paylasim' => $db->query("SELECT COUNT(*) as count FROM paylasimlar WHERE DATE(tarih) = CURDATE()")->fetch()['count'],
    'bu_hafta_paylasim' => $db->query("SELECT COUNT(*) as count FROM paylasimlar WHERE tarih >= DATE_SUB(NOW(), INTERVAL 7 DAY)")->fetch()['count'],
    'bu_ay_paylasim' => $db->query("SELECT COUNT(*) as count FROM paylasimlar WHERE MONTH(tarih) = MONTH(NOW()) AND YEAR(tarih) = YEAR(NOW())")->fetch()['count'],
    'sifreli_paylasim' => $db->query("SELECT COUNT(*) as count FROM paylasimlar WHERE sifre IS NOT NULL")->fetch()['count'],
    'toplam_kullanici' => $db->query("SELECT COUNT(*) as count FROM kullanicilar")->fetch()['count'],
    'aktif_kullanici' => $db->query("SELECT COUNT(*) as count FROM kullanicilar WHERE durum = 1")->fetch()['count']
];

// Son 7 günün verileri (grafik için)
$son_7_gun = [];
for ($i = 6; $i >= 0; $i--) {
    $tarih = date('Y-m-d', strtotime("-$i days"));
    $count = $db->query("SELECT COUNT(*) as count FROM paylasimlar WHERE DATE(tarih) = '$tarih'")->fetch()['count'];
    $son_7_gun[] = [
        'tarih' => date('d.m', strtotime($tarih)),
        'sayi' => $count
    ];
}

// En çok görüntülenen paylaşımlar
$populer_paylasimlar = $db->query("SELECT id, baslik, goruntulenme, tarih FROM paylasimlar ORDER BY goruntulenme DESC LIMIT 10")->fetchAll();

// IP istatistikleri
$ip_stats = $db->query("SELECT ip_adresi, COUNT(*) as count FROM paylasimlar GROUP BY ip_adresi ORDER BY count DESC LIMIT 10")->fetchAll();

// Aylık trend
$aylik_trend = [];
for ($i = 11; $i >= 0; $i--) {
    $ay = date('Y-m', strtotime("-$i months"));
    $count = $db->query("SELECT COUNT(*) as count FROM paylasimlar WHERE DATE_FORMAT(tarih, '%Y-%m') = '$ay'")->fetch()['count'];
    $aylik_trend[] = [
        'ay' => date('M Y', strtotime($ay . '-01')),
        'sayi' => $count
    ];
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>İstatistikler - Admin Panel</title>
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/admin.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body data-bs-theme="<?php echo $varsayilan_tema; ?>">
    <!-- Sidebar -->
    <div class="sidebar">
        <div class="sidebar-header">
            <h5 class="mb-0"><i class="bi bi-shield-lock text-primary me-2"></i>Admin Panel</h5>
            <small class="text-muted">MetinPaylaş</small>
        </div>
        <nav class="sidebar-nav">
            <a href="dashboard.php" class="nav-link"><i class="bi bi-speedometer2"></i>Dashboard</a>
            <a href="paylasimlar.php" class="nav-link"><i class="bi bi-file-text"></i>Paylaşımlar</a>
            <a href="kullanicilar.php" class="nav-link"><i class="bi bi-people"></i>Kullanıcılar</a>
            <a href="ayarlar.php" class="nav-link"><i class="bi bi-gear"></i>Site Ayarları</a>
            <a href="istatistikler.php" class="nav-link active"><i class="bi bi-bar-chart"></i>İstatistikler</a>
            <a href="guvenlik.php" class="nav-link"><i class="bi bi-shield-check"></i>Güvenlik</a>
            <hr class="my-3">
            <a href="../index.php" class="nav-link" target="_blank"><i class="bi bi-box-arrow-up-right"></i>Siteyi Görüntüle</a>
            <a href="cikis.php" class="nav-link text-danger"><i class="bi bi-box-arrow-right"></i>Çıkış Yap</a>
        </nav>
    </div>
    
    <!-- Ana İçerik -->
    <div class="main-content">
        <div class="top-bar">
            <div>
                <h4 class="mb-0">İstatistikler</h4>
                <small class="text-muted">Detaylı site istatistikleri ve raporlar</small>
            </div>
            <div>
                <button class="btn btn-outline-secondary btn-sm me-2" id="temaDegistir" title="Tema Değiştir">
                    <i class="bi bi-sun"></i>
                </button>
                <span class="badge bg-primary"><?php echo $_SESSION['admin_yetki']; ?></span>
            </div>
        </div>
        
        <!-- Ana İstatistikler -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="stat-card">
                    <div class="d-flex align-items-center">
                        <div class="stat-icon bg-primary"><i class="bi bi-file-text"></i></div>
                        <div class="ms-3">
                            <p class="stat-number"><?php echo number_format($stats['toplam_paylasim']); ?></p>
                            <p class="stat-label">Toplam Paylaşım</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stat-card">
                    <div class="d-flex align-items-center">
                        <div class="stat-icon bg-success"><i class="bi bi-eye"></i></div>
                        <div class="ms-3">
                            <p class="stat-number"><?php echo number_format($stats['toplam_goruntulenme']); ?></p>
                            <p class="stat-label">Toplam Görüntülenme</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stat-card">
                    <div class="d-flex align-items-center">
                        <div class="stat-icon bg-info"><i class="bi bi-calendar-day"></i></div>
                        <div class="ms-3">
                            <p class="stat-number"><?php echo number_format($stats['bugun_paylasim']); ?></p>
                            <p class="stat-label">Bugünkü Paylaşım</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stat-card">
                    <div class="d-flex align-items-center">
                        <div class="stat-icon bg-warning"><i class="bi bi-people"></i></div>
                        <div class="ms-3">
                            <p class="stat-number"><?php echo number_format($stats['toplam_kullanici']); ?></p>
                            <p class="stat-label">Toplam Kullanıcı</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Zaman Bazlı İstatistikler -->
        <div class="row mb-4">
            <div class="col-md-4">
                <div class="stat-card">
                    <div class="text-center">
                        <div class="stat-icon bg-success mx-auto mb-3"><i class="bi bi-calendar-week"></i></div>
                        <p class="stat-number"><?php echo number_format($stats['bu_hafta_paylasim']); ?></p>
                        <p class="stat-label">Bu Hafta</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="stat-card">
                    <div class="text-center">
                        <div class="stat-icon bg-info mx-auto mb-3"><i class="bi bi-calendar-month"></i></div>
                        <p class="stat-number"><?php echo number_format($stats['bu_ay_paylasim']); ?></p>
                        <p class="stat-label">Bu Ay</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="stat-card">
                    <div class="text-center">
                        <div class="stat-icon bg-danger mx-auto mb-3"><i class="bi bi-shield-lock"></i></div>
                        <p class="stat-number"><?php echo number_format($stats['sifreli_paylasim']); ?></p>
                        <p class="stat-label">Şifreli Paylaşım</p>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Grafikler -->
        <div class="row mb-4">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="bi bi-graph-up me-2"></i>Son 7 Günün Paylaşım Trendi</h5>
                    </div>
                    <div class="card-body">
                        <canvas id="weeklyChart" height="100"></canvas>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="bi bi-pie-chart me-2"></i>Paylaşım Türleri</h5>
                    </div>
                    <div class="card-body">
                        <canvas id="typeChart"></canvas>
                        <div class="mt-3">
                            <div class="d-flex justify-content-between">
                                <span>Açık Paylaşımlar</span>
                                <strong><?php echo number_format($stats['toplam_paylasim'] - $stats['sifreli_paylasim']); ?></strong>
                            </div>
                            <div class="d-flex justify-content-between">
                                <span>Şifreli Paylaşımlar</span>
                                <strong><?php echo number_format($stats['sifreli_paylasim']); ?></strong>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Detaylı Tablolar -->
        <div class="row">
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="bi bi-trophy me-2"></i>En Popüler Paylaşımlar</h5>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>Başlık</th>
                                        <th>Görüntülenme</th>
                                        <th>Tarih</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($populer_paylasimlar as $paylasim): ?>
                                        <tr>
                                            <td>
                                                <a href="../goster.php?id=<?php echo $paylasim['id']; ?>" target="_blank" class="text-decoration-none">
                                                    <?php echo htmlspecialchars($paylasim['baslik'] ?: 'Başlıksız'); ?>
                                                </a>
                                            </td>
                                            <td>
                                                <span class="badge bg-success"><?php echo number_format($paylasim['goruntulenme']); ?></span>
                                            </td>
                                            <td>
                                                <small><?php echo date('d.m.Y', strtotime($paylasim['tarih'])); ?></small>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="bi bi-globe me-2"></i>En Aktif IP Adresleri</h5>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>IP Adresi</th>
                                        <th>Paylaşım Sayısı</th>
                                        <th>Oran</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($ip_stats as $ip): ?>
                                        <tr>
                                            <td>
                                                <code><?php echo htmlspecialchars($ip['ip_adresi']); ?></code>
                                            </td>
                                            <td>
                                                <?php echo number_format($ip['count']); ?>
                                            </td>
                                            <td>
                                                <div class="progress" style="height: 10px;">
                                                    <div class="progress-bar bg-primary" style="width: <?php echo ($ip['count'] / $stats['toplam_paylasim']) * 100; ?>%"></div>
                                                </div>
                                                <small class="text-muted"><?php echo number_format(($ip['count'] / $stats['toplam_paylasim']) * 100, 1); ?>%</small>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Aylık Trend Grafiği -->
        <div class="row mt-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="bi bi-calendar-range me-2"></i>Aylık Paylaşım Trendi (Son 12 Ay)</h5>
                    </div>
                    <div class="card-body">
                        <canvas id="monthlyChart" height="60"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Tema değiştirme
        document.addEventListener('DOMContentLoaded', function() {
            const themeToggle = document.getElementById('temaDegistir');
            if (themeToggle) {
                let currentTheme = document.body.getAttribute('data-bs-theme') || 'light';
                updateThemeIcon(currentTheme);
                
                themeToggle.addEventListener('click', function() {
                    const newTheme = currentTheme === 'dark' ? 'light' : 'dark';
                    document.body.setAttribute('data-bs-theme', newTheme);
                    document.documentElement.setAttribute('data-bs-theme', newTheme);
                    localStorage.setItem('theme', newTheme);
                    updateThemeIcon(newTheme);
                    currentTheme = newTheme;
                    
                    document.body.classList.add('theme-transition');
                    setTimeout(() => document.body.classList.remove('theme-transition'), 300);
                    
                    fetch('tema-degistir.php', {
                        method: 'POST',
                        headers: { 'Content-Type': 'application/json' },
                        body: JSON.stringify({ tema: newTheme })
                    }).catch(console.error);
                });
                
                function updateThemeIcon(theme) {
                    const icon = themeToggle.querySelector('i');
                    if (icon) icon.className = theme === 'dark' ? 'bi bi-sun' : 'bi bi-moon';
                }
            }
            
            // Grafikler
            initCharts();
        });
        
        function initCharts() {
            const isDark = document.body.getAttribute('data-bs-theme') === 'dark';
            const textColor = isDark ? '#f1f5f9' : '#1e293b';
            const gridColor = isDark ? '#334155' : '#e2e8f0';
            
            // Haftalık grafik
            const weeklyData = <?php echo json_encode($son_7_gun); ?>;
            new Chart(document.getElementById('weeklyChart'), {
                type: 'line',
                data: {
                    labels: weeklyData.map(d => d.tarih),
                    datasets: [{
                        label: 'Paylaşım Sayısı',
                        data: weeklyData.map(d => d.sayi),
                        borderColor: '#6366f1',
                        backgroundColor: 'rgba(99, 102, 241, 0.1)',
                        tension: 0.4,
                        fill: true
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: { display: false }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            ticks: { color: textColor },
                            grid: { color: gridColor }
                        },
                        x: {
                            ticks: { color: textColor },
                            grid: { color: gridColor }
                        }
                    }
                }
            });
            
            // Tip grafiği
            new Chart(document.getElementById('typeChart'), {
                type: 'doughnut',
                data: {
                    labels: ['Açık', 'Şifreli'],
                    datasets: [{
                        data: [<?php echo $stats['toplam_paylasim'] - $stats['sifreli_paylasim']; ?>, <?php echo $stats['sifreli_paylasim']; ?>],
                        backgroundColor: ['#10b981', '#f59e0b']
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: { display: false }
                    }
                }
            });
            
            // Aylık trend grafiği
            const monthlyData = <?php echo json_encode($aylik_trend); ?>;
            new Chart(document.getElementById('monthlyChart'), {
                type: 'bar',
                data: {
                    labels: monthlyData.map(d => d.ay),
                    datasets: [{
                        label: 'Paylaşım Sayısı',
                        data: monthlyData.map(d => d.sayi),
                        backgroundColor: '#6366f1',
                        borderRadius: 4
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: { display: false }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            ticks: { color: textColor },
                            grid: { color: gridColor }
                        },
                        x: {
                            ticks: { color: textColor },
                            grid: { color: gridColor }
                        }
                    }
                }
            });
        }
    </script>
</body>
</html>

