<?php
/**
 * MetinPaylaş - Gösterim Sayfası
 * 
 * Paylaşılan metinlerin görüntülendiği sayfa
 */

// Gerekli dosyaları dahil et
require_once 'includes/config.php';
require_once 'includes/functions.php';

// Ayarları getir
$ayarlar = ayarlariGetir();
$varsayilan_tema = isset($ayarlar['tema']) ? $ayarlar['tema'] : 'light';
$site_baslik = isset($ayarlar['site_baslik']) ? $ayarlar['site_baslik'] : 'MetinPaylaş';
$site_aciklama = isset($ayarlar['site_aciklama']) ? $ayarlar['site_aciklama'] : 'Hızlı ve kolay metin paylaşım platformu';

// ID parametresi kontrolü
if (!isset($_GET['id']) || empty($_GET['id'])) {
    header('Location: index.php');
    exit;
}

$id = $_GET['id'];
$paylasim = metinGetir($id);

// Paylaşım bulunamadıysa ana sayfaya yönlendir
if (!$paylasim) {
    $_SESSION['hata'] = 'Aradığınız metin bulunamadı veya süresi dolmuş.';
    header('Location: index.php');
    exit;
}

// Şifre korumalı paylaşım kontrolü
$sifreKorumali = !empty($paylasim['sifre']);
$sifreDogrulandi = false;

if ($sifreKorumali) {
    // Şifre gönderildi mi kontrol et (sadece şifre doğrulama formu için)
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['sifre_dogrulama_formu']) && isset($_POST['sifre'])) {
        if (sifreKontrol($id, $_POST['sifre'])) {
            $sifreDogrulandi = true;
            $_SESSION['dogrulanan_' . $paylasim['id']] = true;
            // Başarılı şifre doğrulaması sonrası aynı sayfaya yönlendir (POST/Redirect/GET pattern)
            header('Location: goster.php?id=' . $id);
            exit;
        } else {
            $sifreHatasi = 'Yanlış şifre girdiniz.';
        }
    }
    
    // Oturumda doğrulanmış mı kontrol et
    if (isset($_SESSION['dogrulanan_' . $paylasim['id']]) && $_SESSION['dogrulanan_' . $paylasim['id']] === true) {
        $sifreDogrulandi = true;
    }
}

// HTML içeriği doğrudan kullan
$metinIcerik = $paylasim['metin'];

// Başlık
$baslik = !empty($paylasim['baslik']) ? $paylasim['baslik'] : 'Metin #' . $paylasim['id'];
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($baslik); ?> - <?php echo htmlspecialchars($site_baslik); ?></title>
    <meta name="description" content="<?php echo substr(strip_tags($metinIcerik), 0, 160); ?>">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&family=Fira+Code:wght@400;500&display=swap" rel="stylesheet">
    
    <!-- Özel CSS -->
    <link rel="stylesheet" href="assets/css/style.css">
    
    <!-- Highlight.js - Kod renklendirme -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/gh/highlightjs/cdn-release@11.7.0/build/styles/github.min.css">
    
    <!-- Favicon -->
    <link rel="shortcut icon" href="assets/img/favicon.ico" type="image/x-icon">
</head>
<body data-bs-theme="<?php echo $varsayilan_tema; ?>">
    <div class="container py-4">
        <!-- Başlık -->
        <header class="text-center mb-4">
            <div class="position-absolute top-0 end-0 p-3">
                <button class="btn btn-sm btn-outline-secondary rounded-circle" id="temaDegistir" title="Tema Değiştir">
                    <i class="bi bi-moon-stars"></i>
                </button>
            </div>
            <h1 class="display-5 fw-bold"><?php echo htmlspecialchars($site_baslik); ?></h1>
            <p class="lead"><?php echo htmlspecialchars($site_aciklama); ?></p>
        </header>
        
        <!-- Ana İçerik -->
        <main>
            <div class="card shadow-sm">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <div class="d-flex align-items-center">
                        <i class="bi bi-file-earmark-text me-2 text-primary"></i>
                        <span class="fw-medium">Metin Görüntüleme</span>
                    </div>
                    <div>
                        <a href="index.php" class="btn btn-sm btn-primary d-flex align-items-center">
                            <i class="bi bi-plus-lg me-1"></i> Yeni Metin
                        </a>
                    </div>
                </div>
                
                <div class="card-body">
                    <?php if ($sifreKorumali && !$sifreDogrulandi): ?>
                        <!-- Şifre Doğrulama Formu -->
                        <div class="text-center py-5">
                            <div class="mb-4">
                                <div class="display-1 text-warning mb-3">
                                    <i class="bi bi-shield-lock-fill"></i>
                                </div>
                                <h3 class="mb-2">Bu içerik şifre korumalıdır</h3>
                                <p class="text-muted">Görüntülemek için şifreyi girin</p>
                            </div>
                            
                            <div class="row justify-content-center">
                                <div class="col-md-6">
                                    <form method="post" action="goster.php?id=<?php echo htmlspecialchars($id, ENT_QUOTES, 'UTF-8'); ?>">
                                        <!-- Şifre doğrulama formu tanımlayıcısı -->
                                        <input type="hidden" name="sifre_dogrulama_formu" value="1">
                                        
                                        <div class="mb-4">
                                            <div class="input-group shadow-sm">
                                                <span class="input-group-text bg-light border-light">
                                                    <i class="bi bi-key"></i>
                                                </span>
                                                <input type="password" class="form-control form-control-lg" name="sifre" 
                                                       placeholder="Şifre girin" required autocomplete="new-password">
                                                <button type="submit" class="btn btn-primary px-4">
                                                    <i class="bi bi-unlock me-2"></i>Doğrula
                                                </button>
                                            </div>
                                            <?php if (isset($sifreHatasi)): ?>
                                                <div class="alert alert-danger mt-3">
                                                    <i class="bi bi-exclamation-triangle-fill me-2"></i>
                                                    <?php echo $sifreHatasi; ?>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            
                            <div class="mt-4">
                                <a href="index.php" class="btn btn-outline-secondary">
                                    <i class="bi bi-arrow-left me-2"></i>Ana Sayfaya Dön
                                </a>
                            </div>
                        </div>
                    <?php else: ?>
                        <!-- Metin Bilgileri Üst Kısım -->
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <div class="d-flex align-items-center">
                                <div class="badge bg-primary me-2 p-2">
                                    <i class="bi bi-file-earmark-text"></i>
                                </div>
                                <div>
                                    <h5 class="mb-0 fw-bold"><?php echo htmlspecialchars($baslik); ?></h5>
                                    <div class="text-muted small">
                                        <i class="bi bi-calendar-event me-1"></i> <?php echo tarihFormati($paylasim['tarih']); ?>
                                    </div>
                                </div>
                            </div>
                            <div>
                                <?php if ($silinme_suresi = $paylasim['silinme_suresi']): ?>
                                    <?php
                                    $olusturulma = new DateTime($paylasim['tarih']);
                                    $silinme = clone $olusturulma;
                                    $silinme->add(new DateInterval('PT' . $silinme_suresi . 'M'));
                                    $simdi = new DateTime();
                                    $kalan = $simdi->diff($silinme);
                                    $kalanSure = '';
                                    
                                    if ($kalan->days > 0) {
                                        $kalanSure = $kalan->days . ' gün';
                                    } elseif ($kalan->h > 0) {
                                        $kalanSure = $kalan->h . ' saat';
                                    } else {
                                        $kalanSure = $kalan->i . ' dakika';
                                    }
                                    ?>
                                    <div class="badge bg-warning text-dark">
                                        <i class="bi bi-alarm me-1"></i> <?php echo $kalanSure; ?> sonra silinecek
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <!-- Metin İçeriği -->
                        <div class="metin-container p-4 rounded shadow-sm mb-4">
                            <div class="html-content">
                                <?php echo $metinIcerik; ?>
                            </div>
                        </div>
                        
                        <!-- Resimler Varsa Göster -->
                        <?php if (!empty($paylasim['resimler'])): ?>
                            <div class="mb-4">
                                <h6 class="mb-3 fw-bold"><i class="bi bi-images me-2"></i>Eklenen Resimler</h6>
                                <div class="row g-3">
                                    <?php foreach ($paylasim['resimler'] as $resim): ?>
                                        <div class="col-md-4 col-sm-6">
                                            <div class="card h-100">
                                                <img src="<?php echo $resim['dosya_yolu']; ?>" class="card-img-top" alt="<?php echo htmlspecialchars($resim['dosya_adi']); ?>">
                                                <div class="card-body">
                                                    <p class="card-text small text-muted mb-0"><?php echo htmlspecialchars($resim['dosya_adi']); ?></p>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                        
                        <!-- Metin Bilgileri Alt Kısım -->
                        <?php if (!isset($paylasim['goruntu_sayaci_goster']) || $paylasim['goruntu_sayaci_goster']): ?>
                            <div class="d-flex flex-wrap justify-content-between align-items-center mb-4">
                                <div class="d-flex flex-wrap gap-3 text-muted small">
                                    <span class="d-flex align-items-center" title="Görüntülenme Sayısı">
                                        <i class="bi bi-eye me-1"></i> <?php echo $paylasim['goruntulenme']; ?> görüntülenme
                                    </span>
                                    <span class="d-flex align-items-center" title="Karakter Sayısı">
                                        <i class="bi bi-hash me-1"></i> <?php echo strlen($paylasim['metin']); ?> karakter
                                    </span>
                                    <span class="d-flex align-items-center" title="Satır Sayısı">
                                        <i class="bi bi-list-ol me-1"></i> <?php echo substr_count($paylasim['metin'], "\n") + 1; ?> satır
                                    </span>
                                </div>
                                
                                <div class="d-flex align-items-center">
                                    <!-- HTML görünüm seçenekleri kaldırıldı -->
                                </div>
                            </div>
                        <?php endif; ?>
                        
                        <!-- İşlem Butonları -->
                        <div class="card bg-light border-0 rounded-3 p-3">
                            <div class="card-body p-0">
                                <h6 class="mb-3 fw-bold"><i class="bi bi-gear me-2"></i>İşlemler</h6>
                                <div class="d-flex flex-wrap gap-2">
                                    <button class="btn btn-primary d-flex align-items-center" onclick="metniKopyala()">
                                        <i class="bi bi-clipboard me-2"></i> Metni Kopyala
                                    </button>
                                    
                                    <button class="btn btn-outline-primary d-flex align-items-center" onclick="linkKopyala()">
                                        <i class="bi bi-link-45deg me-2"></i> Bağlantıyı Kopyala
                                    </button>
                                    
                                    <button class="btn btn-outline-secondary d-flex align-items-center" onclick="qrKodGoster()">
                                        <i class="bi bi-qr-code me-2"></i> QR Kod
                                    </button>
                                    
                                    <a href="index.php" class="btn btn-outline-secondary d-flex align-items-center">
                                        <i class="bi bi-plus-lg me-2"></i> Yeni Metin
                                    </a>
                                    
                                    <button class="btn btn-outline-info d-flex align-items-center" onclick="yazdir()">
                                        <i class="bi bi-printer me-2"></i> Yazdır
                                    </button>
                                </div>
                            </div>
                        </div>
                        
                        <!-- QR Kod Modalı -->
                        <div class="modal fade" id="qrKodModal" tabindex="-1" aria-hidden="true">
                            <div class="modal-dialog modal-sm">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title d-flex align-items-center">
                                            <i class="bi bi-qr-code me-2"></i>QR Kod
                                        </h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Kapat"></button>
                                    </div>
                                    <div class="modal-body text-center p-4">
                                        <div class="bg-white p-2 rounded shadow-sm d-inline-block mb-3">
                                            <img id="qrKodResim" src="https://api.qrserver.com/v1/create-qr-code/?size=200x200&data=<?php echo urlencode(SITE_URL . '/goster.php?id=' . $id); ?>" 
                                                 alt="QR Kod" class="img-fluid">
                                        </div>
                                        <p class="mb-0 text-muted">Bu QR kodu taratarak metne ulaşabilirsiniz</p>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                                            <i class="bi bi-x me-1"></i>Kapat
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </main>
        
 
    </div>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Highlight.js - Kod renklendirme -->
    <script src="https://cdn.jsdelivr.net/gh/highlightjs/cdn-release@11.7.0/build/highlight.min.js"></script>
    
    <!-- Özel JS -->
    <script src="assets/js/script.js"></script>
    
    <script>
        // Kod bloklarını renklendir
        document.addEventListener('DOMContentLoaded', function() {
            document.querySelectorAll('pre code').forEach((block) => {
                hljs.highlightBlock(block);
            });
        });
        
        // Toast bildirimi gösterme fonksiyonu
        function showToast(message, type = 'success') {
            // Toast elementi oluştur
            const toastEl = document.createElement('div');
            toastEl.className = `toast align-items-center text-white bg-${type} border-0`;
            toastEl.setAttribute('role', 'alert');
            toastEl.setAttribute('aria-live', 'assertive');
            toastEl.setAttribute('aria-atomic', 'true');
            
            const flexBox = document.createElement('div');
            flexBox.className = 'd-flex';
            
            const toastBody = document.createElement('div');
            toastBody.className = 'toast-body d-flex align-items-center';
            
            // İkon ekle
            const icon = document.createElement('i');
            icon.className = type === 'success' ? 'bi bi-check-circle-fill me-2' : 'bi bi-exclamation-triangle-fill me-2';
            toastBody.appendChild(icon);
            
            // Mesaj ekle
            toastBody.appendChild(document.createTextNode(message));
            
            // Kapat butonu ekle
            const closeBtn = document.createElement('button');
            closeBtn.type = 'button';
            closeBtn.className = 'btn-close btn-close-white ms-auto me-2';
            closeBtn.setAttribute('data-bs-dismiss', 'toast');
            closeBtn.setAttribute('aria-label', 'Kapat');
            
            flexBox.appendChild(toastBody);
            flexBox.appendChild(closeBtn);
            toastEl.appendChild(flexBox);
            
            // Toast konteyner oluştur veya mevcut olanı bul
            let toastContainer = document.querySelector('.toast-container');
            if (!toastContainer) {
                toastContainer = document.createElement('div');
                toastContainer.className = 'toast-container position-fixed bottom-0 end-0 p-3';
                document.body.appendChild(toastContainer);
            }
            
            // Toast'u konteynere ekle
            toastContainer.appendChild(toastEl);
            
            // Bootstrap Toast nesnesini oluştur ve göster
            const toast = new bootstrap.Toast(toastEl, {
                animation: true,
                autohide: true,
                delay: 3000
            });
            toast.show();
            
            // Kapatıldıktan sonra DOM'dan kaldır
            toastEl.addEventListener('hidden.bs.toast', function () {
                toastEl.remove();
            });
        }
        
        // Metin kopyalama fonksiyonu
        function metniKopyala() {
            const metin = document.querySelector('.metin-content') ? 
                          document.querySelector('.metin-content').innerText : 
                          document.querySelector('.markdown-content').innerText;
                          
            navigator.clipboard.writeText(metin).then(() => {
                showToast('Metin panoya kopyalandı!');
            }).catch(err => {
                showToast('Kopyalama işlemi başarısız oldu.', 'danger');
                console.error('Kopyalama hatası:', err);
            });
        }
        
        // Bağlantı kopyalama fonksiyonu
        function linkKopyala() {
            navigator.clipboard.writeText(window.location.href).then(() => {
                showToast('Bağlantı panoya kopyalandı!');
            }).catch(err => {
                showToast('Kopyalama işlemi başarısız oldu.', 'danger');
                console.error('Kopyalama hatası:', err);
            });
        }
        
        // QR kod modalını göster
        function qrKodGoster() {
            const qrModal = new bootstrap.Modal(document.getElementById('qrKodModal'));
            qrModal.show();
        }
        
        // Yazdırma fonksiyonu
        function yazdir() {
            window.print();
        }
    </script>
    
    <!-- Footer - Korumalı Bölüm -->
    <?php
    // Footer güvenlik sistemi
    define('FOOTER_SECURITY_ALLOWED', true);
    require_once 'includes/footer-security.php';
    echo FooterSecurity::renderFooter();
    ?>
</body>
</html>