<?php
/**
 * MetinPaylaş - Ana Sayfa
 * 
 * Metin girişi ve paylaşım oluşturma sayfası
 */

// Gerekli dosyaları dahil et
require_once 'includes/config.php';
require_once 'includes/functions.php';

// Ayarları getir
$ayarlar = ayarlariGetir();
$markdown_varsayilan = isset($ayarlar['markdown_varsayilan']) ? (bool)$ayarlar['markdown_varsayilan'] : true;
$varsayilan_tema = isset($ayarlar['tema']) ? $ayarlar['tema'] : 'light';
$site_baslik = isset($ayarlar['site_baslik']) ? $ayarlar['site_baslik'] : 'MetinPaylaş';
$site_aciklama = isset($ayarlar['site_aciklama']) ? $ayarlar['site_aciklama'] : 'Hızlı ve kolay metin paylaşım platformu';

// Form gönderildi mi kontrol et (sadece metin paylaşım formu için)
$sonuc = null;
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['metin_paylasim_formu'])) {
    // Rate limit kontrolü (5 saniye içinde yeni paylaşım yapılamaz)
    if (isset($_SESSION['son_paylasim']) && (time() - $_SESSION['son_paylasim']) < 5) {
        $sonuc = [
            'basarili' => false,
            'mesaj' => 'Çok hızlı işlem yapıyorsunuz. Lütfen birkaç saniye bekleyin.'
        ];
    } else {
        // Form verilerini al
        $baslik = isset($_POST['baslik']) ? $_POST['baslik'] : '';
        $metin = isset($_POST['metin']) ? $_POST['metin'] : '';
        $sifre = !empty($_POST['sifre']) ? $_POST['sifre'] : null;
        $silinme_suresi = !empty($_POST['silinme_suresi']) ? (int)$_POST['silinme_suresi'] : null;
        $ozel_url = !empty($_POST['ozel_url']) ? $_POST['ozel_url'] : null;
        $goruntu_sayaci_goster = isset($_POST['goruntu_sayaci_goster']) ? true : false;
        $markdown_kullan = isset($_POST['markdown']) ? true : false;
        
        // Metni oluştur
        $sonuc = metinOlustur($metin, $baslik, $sifre, $silinme_suresi, $ozel_url, $goruntu_sayaci_goster, $markdown_kullan);
        
        // Başarılı ise oturuma kaydet
        if ($sonuc['basarili']) {
            $_SESSION['son_paylasim'] = time();
            
            // Resim yükleme işlemi
            if (isset($_FILES['resimler']) && !empty($_FILES['resimler']['name'][0])) {
                $paylasim_id = $sonuc['id'];
                $resim_sonuclari = [];
                
                // Birden fazla resim yükleme
                for ($i = 0; $i < count($_FILES['resimler']['name']); $i++) {
                    $dosya = [
                        'name' => $_FILES['resimler']['name'][$i],
                        'type' => $_FILES['resimler']['type'][$i],
                        'tmp_name' => $_FILES['resimler']['tmp_name'][$i],
                        'error' => $_FILES['resimler']['error'][$i],
                        'size' => $_FILES['resimler']['size'][$i]
                    ];
                    
                    if ($dosya['error'] === 0) {
                        $resim_sonucu = resimYukle($paylasim_id, $dosya);
                        $resim_sonuclari[] = $resim_sonucu;
                    }
                }
                
                $sonuc['resim_sonuclari'] = $resim_sonuclari;
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($site_baslik); ?> - <?php echo htmlspecialchars($site_aciklama); ?></title>
    <meta name="description" content="<?php echo htmlspecialchars($site_aciklama); ?>">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&family=Fira+Code:wght@400;500&display=swap" rel="stylesheet">
    
    <!-- Özel CSS -->
    <link rel="stylesheet" href="assets/css/style.css">
    
    <!-- CKEditor - WYSIWYG HTML Editor -->
    <script src="https://cdn.ckeditor.com/4.22.1/standard/ckeditor.js"></script>
    
    <!-- Favicon -->
    <link rel="shortcut icon" href="assets/img/favicon.ico" type="image/x-icon">
</head>
<body data-bs-theme="<?php echo $varsayilan_tema; ?>">
    <div class="container py-4">
        <!-- Başlık -->
        <header class="text-center mb-4">
            <div class="position-absolute top-0 end-0 p-3">
                <button class="btn btn-sm btn-outline-secondary rounded-circle" id="temaDegistir" title="Tema Değiştir">
                    <i class="bi bi-moon-stars"></i>
                </button>
            </div>
            <h1 class="display-5 fw-bold"><?php echo htmlspecialchars($site_baslik); ?></h1>
            <p class="lead"><?php echo htmlspecialchars($site_aciklama); ?></p>
        </header>
        
        <!-- Ana İçerik -->
        <main>
            <?php if (isset($sonuc) && $sonuc['basarili']): ?>
                <!-- Başarılı Paylaşım Sonucu -->
                <div class="card border-success shadow-sm">
                    <div class="card-header bg-success text-white d-flex align-items-center">
                        <i class="bi bi-check-circle-fill me-2"></i>
                        <span class="fw-bold">Metniniz başarıyla paylaşıldı!</span>
                    </div>
                    <div class="card-body">
                        <div class="text-center mb-4">
                            <div class="display-1 text-success mb-3">
                                <i class="bi bi-check-circle-fill"></i>
                            </div>
                            <h4 class="mb-3">Paylaşım bağlantınız hazır</h4>
                            <p class="text-muted">Metninize aşağıdaki bağlantıdan ulaşabilirsiniz:</p>
                        </div>
                        
                        <div class="input-group mb-4 shadow-sm">
                            <input type="text" id="paylasimLinki" class="form-control form-control-lg" 
                                   value="<?php echo SITE_URL . '/goster.php?id=' . (!empty($sonuc['ozel_url']) ? $sonuc['ozel_url'] : $sonuc['id']); ?>" readonly>
                            <button class="btn btn-primary" type="button" onclick="linkKopyala()">
                                <i class="bi bi-clipboard me-2"></i>Kopyala
                            </button>
                        </div>
                        
                         <div class="d-flex flex-column flex-md-row gap-3 justify-content-center">
                             <a href="index.php" class="btn btn-outline-primary d-flex align-items-center justify-content-center" onclick="localStorage.removeItem('metinpaylas_editor');">
                                 <i class="bi bi-plus-lg me-2"></i>Yeni Metin Paylaş
                             </a>
                             <a href="goster.php?id=<?php echo !empty($sonuc['ozel_url']) ? $sonuc['ozel_url'] : $sonuc['id']; ?>" class="btn btn-primary d-flex align-items-center justify-content-center">
                                 <i class="bi bi-eye me-2"></i>Metni Görüntüle
                             </a>
                             <button onclick="qrKodGoster()" class="btn btn-outline-secondary d-flex align-items-center justify-content-center">
                                 <i class="bi bi-qr-code me-2"></i>QR Kod
                             </button>
                         </div>
                    </div>
                </div>
                
                <!-- QR Kod Modalı -->
                <div class="modal fade" id="qrKodModal" tabindex="-1" aria-hidden="true">
                    <div class="modal-dialog modal-sm">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title"><i class="bi bi-qr-code me-2"></i>QR Kod</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Kapat"></button>
                            </div>
                            <div class="modal-body text-center">
                                <img id="qrKodResim" src="https://api.qrserver.com/v1/create-qr-code/?size=200x200&data=<?php echo urlencode(SITE_URL . '/goster.php?id=' . (!empty($sonuc['ozel_url']) ? $sonuc['ozel_url'] : $sonuc['id'])); ?>" 
                                     alt="QR Kod" class="img-fluid">
                                <p class="mt-3 mb-0 text-muted">Bu QR kodu taratarak metne ulaşabilirsiniz</p>
                            </div>
                        </div>
                    </div>
                </div>
            <?php else: ?>
                <!-- Metin Giriş Formu -->
                <div class="card shadow-sm">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <span><i class="bi bi-file-earmark-text me-2"></i>Yeni Metin Paylaşımı</span>
                        <div class="nav nav-pills" id="editor-tabs" role="tablist">
                            <button class="nav-link active" id="editor-tab" data-bs-toggle="tab" data-bs-target="#editor-pane" type="button" role="tab" aria-controls="editor-pane" aria-selected="true">
                                <i class="bi bi-pencil-square me-1"></i>Editör
                            </button>
                            <button class="nav-link" id="html-tab" data-bs-toggle="tab" data-bs-target="#html-pane" type="button" role="tab" aria-controls="html-pane" aria-selected="false">
                                <i class="bi bi-code-slash me-1"></i>HTML
                            </button>
                        </div>
                    </div>
                    
                    <div class="card-body">
                        <!-- Kaydedilmiş Metin Bildirimi -->
                        <div id="savedTextNotification" class="alert alert-info alert-dismissible fade" role="alert" style="display: none;">
                            <div class="d-flex align-items-center">
                                <div class="me-3">
                                    <i class="bi bi-clock-history fs-4 text-info"></i>
                                </div>
                                <div class="flex-grow-1">
                                    <h6 class="alert-heading mb-1">Daha önce yazmaya başladığınız bir metin bulundu!</h6>
                                    <p class="mb-0 text-muted">Kaldığınız yerden devam etmek ister misiniz?</p>
                                </div>
                                <div class="ms-3">
                                    <button type="button" class="btn btn-sm btn-success me-2" onclick="devamEtmeKabul()">
                                        <i class="bi bi-check-lg me-1"></i>Evet, Devam Et
                                    </button>
                                    <button type="button" class="btn btn-sm btn-outline-secondary" onclick="devamEtmeReddet()">
                                        <i class="bi bi-x-lg me-1"></i>Hayır, Yeni Yaz
                                    </button>
                                </div>
                            </div>
                        </div>

                        <?php if (isset($sonuc) && !$sonuc['basarili']): ?>
                            <div class="alert alert-danger">
                                <i class="bi bi-exclamation-triangle-fill me-2"></i>
                                <?php echo $sonuc['mesaj']; ?>
                            </div>
                        <?php endif; ?>
                        
                        <form method="post" action="index.php" enctype="multipart/form-data" onsubmit="return formGonderOncesi()">
                            <!-- Form tanımlayıcı -->
                            <input type="hidden" name="metin_paylasim_formu" value="1">
                            
                            <!-- Başlık Alanı -->
                            <div class="mb-3">
                                <input type="text" class="form-control form-control-lg" id="baslik" name="baslik" 
                                       placeholder="Başlık (isteğe bağlı)" autocomplete="off">
                            </div>
                            
                            <div class="tab-content" id="editor-tab-content">
                                <div class="tab-pane fade show active" id="editor-pane" role="tabpanel" aria-labelledby="editor-tab">
                                    <!-- WYSIWYG HTML Editörü -->
                                    <div class="mb-3">
                                        <div id="editor-loading" class="text-center py-3">
                                            <div class="spinner-border text-primary" role="status">
                                                <span class="visually-hidden">Editör yükleniyor...</span>
                                            </div>
                                            <p class="mt-2 text-muted">Editör yükleniyor...</p>
                                        </div>
                                        <textarea class="form-control" id="metin" name="metin" rows="10"
                                                placeholder="Paylaşmak istediğiniz metni buraya yazın..." required></textarea>
                                    </div>
                                </div>
                                <div class="tab-pane fade" id="html-pane" role="tabpanel" aria-labelledby="html-tab">
                                    <!-- HTML Önizleme -->
                                    <div class="mb-3">
                                        <div class="bg-light p-3 rounded" id="html-preview" style="min-height: 300px;"></div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-text d-flex justify-content-between align-items-center mt-2 mb-3">
                                <div>
                                    <i class="bi bi-info-circle me-1"></i>
                                    <span id="karakterSayaci">0</span> karakter
                                </div>
                            </div>
                            
                            <!-- Gelişmiş Ayarlar -->
                            <div class="card mb-4">
                                <div class="card-header bg-light d-flex justify-content-between align-items-center" data-bs-toggle="collapse" data-bs-target="#gelismisAyarlar" aria-expanded="false" aria-controls="gelismisAyarlar" style="cursor: pointer;">
                                    <span>
                                        <i class="bi bi-sliders me-2"></i>
                                        Gelişmiş Ayarlar
                                    </span>
                                    <i class="bi bi-chevron-down"></i>
                                </div>
                                <div class="collapse" id="gelismisAyarlar">
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <label for="sifre" class="form-label">
                                                    <i class="bi bi-shield-lock me-1"></i>
                                                    Şifre Koruması
                                                </label>
                                                <div class="input-group">
                                                    <span class="input-group-text"><i class="bi bi-key"></i></span>
                                                    <input type="password" class="form-control" id="sifre" name="sifre" 
                                                           placeholder="Şifre belirleyin (isteğe bağlı)" autocomplete="new-password">
                                                </div>
                                                <div class="form-text">
                                                    <i class="bi bi-info-circle me-1"></i>
                                                    Boş bırakırsanız herkes erişebilir
                                                </div>
                                            </div>
                                            
                                            <div class="col-md-6 mb-3">
                                                <label for="silinme_suresi" class="form-label">
                                                    <i class="bi bi-alarm me-1"></i>
                                                    Otomatik Silinme Süresi
                                                </label>
                                                <select class="form-select" id="silinme_suresi" name="silinme_suresi">
                                                    <option value="">Silinmesin</option>
                                                    <option value="60">1 Saat Sonra</option>
                                                    <option value="1440">1 Gün Sonra</option>
                                                    <option value="10080">7 Gün Sonra</option>
                                                    <option value="43200">30 Gün Sonra</option>
                                                </select>
                                            </div>
                                        </div>
                                        
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <label for="ozel_url" class="form-label">
                                                    <i class="bi bi-link me-1"></i>
                                                    Özel URL
                                                </label>
                                                <div class="input-group">
                                                    <span class="input-group-text"><?php echo SITE_URL; ?>/goster.php?id=</span>
                                                    <input type="text" class="form-control" id="ozel_url" name="ozel_url" 
                                                           placeholder="ozel-url" pattern="[a-zA-Z0-9\-_]+" title="Sadece harf, rakam, tire ve alt çizgi kullanabilirsiniz">
                                                </div>
                                                <div class="form-text">
                                                    <i class="bi bi-info-circle me-1"></i>
                                                    Özel bir URL belirleyebilirsiniz (isteğe bağlı)
                                                </div>
                                            </div>
                                            
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">
                                                    <i class="bi bi-image me-1"></i>
                                                    Resim Ekle
                                                </label>
                                                <input type="file" class="form-control" name="resimler[]" id="resimler" multiple accept="image/*">
                                                <div class="form-text">
                                                    <i class="bi bi-info-circle me-1"></i>
                                                    En fazla 5 resim ekleyebilirsiniz (JPG, PNG, GIF)
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="row mt-2">
                                            <div class="col-md-6">
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input" type="checkbox" id="goruntu_sayaci_goster" name="goruntu_sayaci_goster" value="1" checked>
                                                    <label class="form-check-label" for="goruntu_sayaci_goster">
                                                        <i class="bi bi-eye me-1"></i>
                                                        Görüntüleme sayacını göster
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <button type="submit" class="btn btn-primary btn-lg w-100 d-flex align-items-center justify-content-center">
                                <i class="bi bi-send-fill me-2"></i>
                                Metni Paylaş
                            </button>
                        </form>
                    </div>
                </div>
            <?php endif; ?>
        </main>
        
 
    </div>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- CKEditor başlatma -->
    <script>
        // CKEditor'ü güvenli bir şekilde başlat
        function initCKEditor() {
            const loadingDiv = document.getElementById('editor-loading');
            
            if (typeof CKEDITOR !== 'undefined') {
                try {
                    CKEDITOR.replace('metin', {
                        language: 'tr',
                        height: 300,
                        toolbar: [
                            { name: 'basicstyles', items: ['Bold', 'Italic', 'Underline', 'Strike', 'RemoveFormat'] },
                            { name: 'paragraph', items: ['NumberedList', 'BulletedList', '-', 'Blockquote', '-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock'] },
                            { name: 'links', items: ['Link', 'Unlink'] },
                            { name: 'insert', items: ['Image', 'Table', 'HorizontalRule', 'SpecialChar'] },
                            { name: 'styles', items: ['Styles', 'Format', 'Font', 'FontSize'] },
                            { name: 'colors', items: ['TextColor', 'BGColor'] },
                            { name: 'tools', items: ['Maximize'] }
                        ],
                        removePlugins: 'elementspath',
                        resize_enabled: false,
                        skin: 'moono-lisa',
                        on: {
                            instanceReady: function(evt) {
                                // Loading göstergesini gizle
                                if (loadingDiv) {
                                    loadingDiv.style.display = 'none';
                                }
                                
                                // Global referans sakla
                                window.mainCKEditor = evt.editor;
                            }
                        }
                    });
                } catch (error) {
                    console.error('CKEditor yüklenemedi:', error);
                    // Loading göstergesini gizle ve normal textarea'yı göster
                    if (loadingDiv) {
                        loadingDiv.style.display = 'none';
                    }
                }
            } else {
                console.error('CKEditor kütüphanesi yüklenemedi');
                // Loading göstergesini gizle ve normal textarea'yı göster
                if (loadingDiv) {
                    loadingDiv.style.display = 'none';
                }
                
                // Normal textarea için otomatik kayıt sistemi
                setupTextareaAutoSave();
            }
        }
        
        // Normal textarea için otomatik kayıt sistemi
        function setupTextareaAutoSave() {
            const textarea = document.getElementById('metin');
            if (!textarea) return;
            
            // Kaydedilmiş metin kontrolü
            const savedText = localStorage.getItem("metinpaylas_editor");
            if (savedText && savedText.trim() !== '') {
                // Textarea referansını kaydet
                window.currentTextarea = textarea;
                window.savedText = savedText;
                
                // Sayfa içi bildirimi göster
                showSavedTextNotification();
            }
            
            // Değişiklik olayları
            textarea.addEventListener('input', function() {
                const text = this.value;
                
                // Sadece boş değilse kaydet
                if (text.trim() !== '') {
                    localStorage.setItem("metinpaylas_editor", text);
                } else {
                    localStorage.removeItem("metinpaylas_editor");
                }
                
                // Karakter sayacını güncelle
                if (karakterSayaci) {
                    karakterSayaci.textContent = text.length;
                }
                
                // HTML önizleme güncelle (basit)
                if (htmlPreview) {
                    htmlPreview.innerHTML = text.replace(/\n/g, '<br>');
                }
            });
        }

        // Sayfa yüklendiğinde CKEditor'ü başlat
        if (document.readyState === 'loading') {
            document.addEventListener('DOMContentLoaded', initCKEditor);
        } else {
            initCKEditor();
        }
    </script>
    
    <!-- Özel JS -->
    <script src="assets/js/script.js"></script>
    
    <script>
        // Başarılı paylaşım sonrası localStorage'ı temizle
        <?php if (isset($sonuc) && $sonuc['basarili']): ?>
            localStorage.removeItem('metinpaylas_editor');
        <?php endif; ?>
        
        // HTML Editör için karakter sayacı
        const karakterSayaci = document.getElementById('karakterSayaci');
        const htmlPreview = document.getElementById('html-preview');
        
        // CKEditor yüklendikten sonra
        if (typeof CKEDITOR !== 'undefined') {
            CKEDITOR.on('instanceReady', function(evt) {
                const editor = evt.editor;
                
                // Editör hazır, debug bilgisi
                console.log('CKEditor başarıyla yüklendi ve hazır');
                
                // Kaydedilmiş metin kontrolü ve kullanıcıya sorma
                const savedText = localStorage.getItem("metinpaylas_editor");
                if (savedText && savedText.trim() !== '') {
                    // Editör referansını kaydet
                    window.currentEditor = editor;
                    window.savedText = savedText;
                    
                    // Sayfa içi bildirimi göster
                    showSavedTextNotification();
                }
                
                // Değişiklik olayı
                editor.on('change', function() {
                    const text = editor.getData();
                    
                    // Sadece boş değilse kaydet
                    if (text.trim() !== '') {
                        localStorage.setItem("metinpaylas_editor", text);
                    } else {
                        localStorage.removeItem("metinpaylas_editor");
                    }
                    
                    // HTML önizleme güncelleme
                    if (htmlPreview) {
                        htmlPreview.innerHTML = text;
                    }
                    
                    // Karakter sayacını güncelle
                    if (karakterSayaci) {
                        karakterSayaci.textContent = text.replace(/<[^>]*>/g, '').length;
                    }
                });
                
                // İlk yüklemede karakter sayacını güncelle
                if (karakterSayaci) {
                    karakterSayaci.textContent = editor.getData().replace(/<[^>]*>/g, '').length;
                }
                
                // HTML önizlemeyi güncelle
                if (htmlPreview) {
                    htmlPreview.innerHTML = editor.getData();
                }
            });
        }
        
        // Toast bildirimi gösterme fonksiyonu
        function showToast(message, type = 'success') {
            // Toast elementi oluştur
            const toastEl = document.createElement('div');
            toastEl.className = `toast align-items-center text-white bg-${type} border-0`;
            toastEl.setAttribute('role', 'alert');
            toastEl.setAttribute('aria-live', 'assertive');
            toastEl.setAttribute('aria-atomic', 'true');
            
            const flexBox = document.createElement('div');
            flexBox.className = 'd-flex';
            
            const toastBody = document.createElement('div');
            toastBody.className = 'toast-body d-flex align-items-center';
            
            // İkon ekle
            const icon = document.createElement('i');
            if (type === 'success') {
                icon.className = 'bi bi-check-circle-fill me-2';
            } else if (type === 'info') {
                icon.className = 'bi bi-info-circle-fill me-2';
            } else {
                icon.className = 'bi bi-exclamation-triangle-fill me-2';
            }
            toastBody.appendChild(icon);
            
            // Mesaj ekle
            toastBody.appendChild(document.createTextNode(message));
            
            // Kapat butonu ekle
            const closeBtn = document.createElement('button');
            closeBtn.type = 'button';
            closeBtn.className = 'btn-close btn-close-white ms-auto me-2';
            closeBtn.setAttribute('data-bs-dismiss', 'toast');
            closeBtn.setAttribute('aria-label', 'Kapat');
            
            flexBox.appendChild(toastBody);
            flexBox.appendChild(closeBtn);
            toastEl.appendChild(flexBox);
            
            // Toast konteyner oluştur veya mevcut olanı bul
            let toastContainer = document.querySelector('.toast-container');
            if (!toastContainer) {
                toastContainer = document.createElement('div');
                toastContainer.className = 'toast-container position-fixed bottom-0 end-0 p-3';
                document.body.appendChild(toastContainer);
            }
            
            // Toast'u konteynere ekle
            toastContainer.appendChild(toastEl);
            
            // Bootstrap Toast nesnesini oluştur ve göster
            const toast = new bootstrap.Toast(toastEl, {
                animation: true,
                autohide: true,
                delay: 3000
            });
            toast.show();
            
            // Kapatıldıktan sonra DOM'dan kaldır
            toastEl.addEventListener('hidden.bs.toast', function () {
                toastEl.remove();
            });
        }
        
        // Bağlantı kopyalama fonksiyonu
        function linkKopyala() {
            const linkInput = document.getElementById('paylasimLinki');
            
            if (linkInput) {
                linkInput.select();
                navigator.clipboard.writeText(linkInput.value)
                    .then(() => showToast('Bağlantı panoya kopyalandı!'))
                    .catch(err => {
                        showToast('Kopyalama işlemi başarısız oldu.', 'danger');
                        console.error('Kopyalama hatası:', err);
                    });
            }
        }
        
        // QR kod modalını göster
        function qrKodGoster() {
            const qrModal = new bootstrap.Modal(document.getElementById('qrKodModal'));
            if (qrModal) {
                qrModal.show();
            }
        }
        
        // Form gönderilmeden önce CKEditor içeriğini kontrol et
        function formGonderOncesi() {
            try {
                // Ana CKEditor instance'ını kontrol et
                if (window.mainCKEditor && typeof window.mainCKEditor.getData === 'function') {
                    const editorData = window.mainCKEditor.getData();
                    const metinTextarea = document.getElementById('metin');
                    if (metinTextarea) {
                        metinTextarea.value = editorData;
                        console.log('CKEditor içeriği aktarıldı:', editorData.length, 'karakter');
                    }
                }
                
                // Alternatif: Tüm CKEditor instance'larını güncelle
                if (typeof CKEDITOR !== 'undefined' && CKEDITOR.instances) {
                    for (let instanceName in CKEDITOR.instances) {
                        try {
                            CKEDITOR.instances[instanceName].updateElement();
                        } catch (e) {
                            console.warn('CKEditor instance güncellenemedi:', instanceName, e);
                        }
                    }
                }
                
                // Son kontrol: Metin alanının dolu olup olmadığını kontrol et
                const metinDegeri = document.getElementById('metin').value;
                if (!metinDegeri || metinDegeri.trim() === '') {
                    showToast('Lütfen paylaşmak istediğiniz metni girin.', 'danger');
                    return false; // Form gönderimini durdur
                }
                
            } catch (error) {
                console.error('Form gönderim öncesi hata:', error);
            }
            
            return true; // Form gönderimini devam ettir
        }
        
        // Kaydedilmiş metin bildirimi gösterme
        function showSavedTextNotification() {
            const notification = document.getElementById('savedTextNotification');
            if (notification) {
                notification.style.display = 'block';
                notification.classList.add('show');
                
                // Yumuşak bir animasyon için
                setTimeout(() => {
                    notification.scrollIntoView({ behavior: 'smooth', block: 'center' });
                }, 100);
            }
        }
        
        // Devam etme onayı - Kabul
        function devamEtmeKabul() {
            const notification = document.getElementById('savedTextNotification');
            const savedText = window.savedText;
            
            if (window.currentEditor) {
                // CKEditor için
                window.currentEditor.setData(savedText);
                showToast('Önceki metniniz geri yüklendi!', 'success');
            } else if (window.currentTextarea) {
                // Normal textarea için
                window.currentTextarea.value = savedText;
                
                // Karakter sayacını güncelle
                if (karakterSayaci) {
                    karakterSayaci.textContent = savedText.length;
                }
                
                // HTML önizleme güncelle
                if (htmlPreview) {
                    htmlPreview.innerHTML = savedText.replace(/\n/g, '<br>');
                }
                
                showToast('Önceki metniniz geri yüklendi!', 'success');
            }
            
            // Bildirimi gizle
            notification.style.display = 'none';
            notification.classList.remove('show');
            
            // Geçici değişkenleri temizle
            delete window.currentEditor;
            delete window.currentTextarea;
            delete window.savedText;
        }
        
        // Devam etme onayı - Reddet
        function devamEtmeReddet() {
            const notification = document.getElementById('savedTextNotification');
            
            // Kayıtlı metni temizle
            localStorage.removeItem("metinpaylas_editor");
            showToast('Yeni bir metin yazmaya başlayabilirsiniz.', 'info');
            
            // Bildirimi gizle
            notification.style.display = 'none';
            notification.classList.remove('show');
            
            // Geçici değişkenleri temizle
            delete window.currentEditor;
            delete window.currentTextarea;
            delete window.savedText;
        }
        
        // Dosya yükleme sınırlaması
        const resimlerInput = document.getElementById('resimler');
        if (resimlerInput) {
            resimlerInput.addEventListener('change', function() {
                if (this.files.length > 5) {
                    showToast('En fazla 5 resim yükleyebilirsiniz.', 'danger');
                    this.value = '';
                }
            });
        }
        
        // Özel URL kontrolü
        const ozelUrlInput = document.getElementById('ozel_url');
        if (ozelUrlInput) {
            ozelUrlInput.addEventListener('input', function() {
                this.value = this.value.replace(/[^a-zA-Z0-9\-_]/g, '');
            });
        }
    </script>
    
    <!-- Footer - Korumalı Bölüm -->
    <?php
    // Footer güvenlik sistemi
    define('FOOTER_SECURITY_ALLOWED', true);
    require_once 'includes/footer-security.php';
    echo FooterSecurity::renderFooter();
    ?>
</body>
</html>