-- MetinPaylaş Veritabanı Yapısı

-- Veritabanını oluştur
CREATE DATABASE IF NOT EXISTS metinpaylas CHARACTER SET utf8mb4 COLLATE utf8mb4_turkish_ci;

-- Veritabanını seç
USE metinpaylas;

-- Paylaşımlar tablosu
CREATE TABLE IF NOT EXISTS paylasimlar (
    id VARCHAR(10) PRIMARY KEY,
    baslik VARCHAR(255) DEFAULT NULL,
    metin TEXT NOT NULL,
    tarih DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    sifre VARCHAR(255) DEFAULT NULL,
    silinme_suresi INT DEFAULT NULL COMMENT 'Dakika cinsinden',
    goruntulenme INT NOT NULL DEFAULT 0,
    ip_adresi VARCHAR(45) NOT NULL,
    ozel_url VARCHAR(100) DEFAULT NULL COMMENT 'Özel URL',
    goruntu_sayaci_goster TINYINT(1) NOT NULL DEFAULT 1 COMMENT 'Görüntüleme sayacını göster',
    markdown_kullan TINYINT(1) NOT NULL DEFAULT 0 COMMENT 'Markdown formatını kullan'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;

-- Kullanıcılar tablosu (admin paneli için)
CREATE TABLE IF NOT EXISTS kullanicilar (
    id INT AUTO_INCREMENT PRIMARY KEY,
    kullanici_adi VARCHAR(50) NOT NULL UNIQUE,
    email VARCHAR(100) NOT NULL UNIQUE,
    sifre VARCHAR(255) NOT NULL,
    ad_soyad VARCHAR(100) DEFAULT NULL,
    yetki ENUM('admin', 'moderator', 'kullanici') NOT NULL DEFAULT 'kullanici',
    kayit_tarihi DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    son_giris DATETIME DEFAULT NULL,
    son_giris_ip VARCHAR(45) DEFAULT NULL COMMENT 'Son giriş IP adresi',
    durum TINYINT(1) NOT NULL DEFAULT 1 COMMENT '1: Aktif, 0: Pasif'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;

-- Resimler tablosu
CREATE TABLE IF NOT EXISTS resimler (
    id INT AUTO_INCREMENT PRIMARY KEY,
    paylasim_id VARCHAR(10) NOT NULL,
    dosya_adi VARCHAR(255) NOT NULL,
    dosya_yolu VARCHAR(255) NOT NULL,
    yuklenme_tarihi DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    boyut INT NOT NULL COMMENT 'Bayt cinsinden',
    FOREIGN KEY (paylasim_id) REFERENCES paylasimlar(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;

-- Admin ayarları tablosu
CREATE TABLE IF NOT EXISTS ayarlar (
    id INT AUTO_INCREMENT PRIMARY KEY,
    anahtar VARCHAR(50) NOT NULL UNIQUE,
    deger TEXT DEFAULT NULL,
    aciklama VARCHAR(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;

-- Örnek veri (test için)
INSERT INTO paylasimlar (id, baslik, metin, tarih, ip_adresi, goruntu_sayaci_goster, markdown_kullan) 
VALUES ('ornek123', 'Hoş Geldiniz', 'Bu bir örnek metin paylaşımıdır. **MetinPaylaş** platformuna hoş geldiniz!', NOW(), '127.0.0.1', 1, 1);

-- Admin kullanıcısı oluştur
INSERT INTO kullanicilar (kullanici_adi, email, sifre, ad_soyad, yetki)
VALUES ('admin', 'admin@metinpaylas.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Site Yöneticisi', 'admin');

-- Temel ayarları ekle
INSERT INTO ayarlar (anahtar, deger, aciklama) VALUES
('site_baslik', 'MetinPaylaş', 'Site başlığı'),
('site_aciklama', 'Hızlı ve kolay metin paylaşım platformu', 'Site açıklaması'),
('max_dosya_boyutu', '5242880', 'Maksimum dosya boyutu (5MB)'),
('izin_verilen_uzantilar', 'jpg,jpeg,png,gif', 'İzin verilen dosya uzantıları'),
('kayit_acik', '1', 'Kullanıcı kaydı açık mı?'),
('tema', 'light', 'Varsayılan tema (light/dark)'),
('markdown_varsayilan', '1', 'Markdown varsayılan olarak açık mı?');